/* Batch rename files. David Ekholm, August 2007 */

import se.datadosen.explorer.*;
import se.datadosen.jalbum.*;
import se.datadosen.util.Replacer;
import se.datadosen.util.IO;
import java.io.*;

msg =
"This tool will batch rename files in the directory according to this pattern:";
JTextField pattern = new JTextField("file%04d");
JCheckBox linksOnly = new JCheckBox("Links only", null, true);
JCheckBox includeFolders = new JCheckBox("Include folders", null, false);
msg2 = 'Supported variables: $name, $label and $folderName';

int answer = JOptionPane.showConfirmDialog(window, new Object[] {msg, pattern, msg2, includeFolders, linksOnly}, "Batch rename files", JOptionPane.OK_CANCEL_OPTION);
if (answer != JOptionPane.OK_OPTION) return;

int index = 1;
Work.on(currentFolder.children)
.titled("Batch renaming files")
.filter(ao -> (ao.isLink() || !linksOnly.isSelected()) && (!ao.folder || includeFolders.selected))
.forEach(ao) -> {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    pw.format(pattern.getText(), new Object[] {new Integer(index)});
    Replacer r = new Replacer();
    String name = ao.getName();
    String folderName = ao.getParent().getName();
    r.add('$name', name);
    r.add('$label', IO.baseName(name));
    r.add('${name}', name);
    r.add('${label}', IO.baseName(name));
    r.add('$folderName', folderName);
    r.add('${folderName}', folderName);
    ao.setName(r.replace(sw.toString()));
    index++;
}
.showResult();
